# VOICE_GUIDE.md
## Preserving Authentic Voice While Strengthening Values Alignment

### The Core Principle

**Make communication MORE HONEST while keeping it AUTHENTICALLY THEIRS.**

Voice preservation isn't about protecting every word—it's about protecting personality, rhythm, and relationship markers so the communication remains recognizably theirs after you've resolved values gaps.

### The Test Question

**"Would someone who knows this person recognize their voice in the revision?"**

If no → You've over-corrected. Go back and restore personality markers.
If yes → You've successfully balanced honesty and authenticity.

### What to Preserve (Always)

1. **Sentence rhythm and length patterns**
   - Short punchy sentences stay short
   - Long flowing sentences stay long
   - Paragraph structure reflects their thinking style

2. **Humor and wit**
   - Jokes, playful language, lighthearted asides
   - Self-deprecating humor
   - Situational callbacks

3. **Personal relationship markers**
   - Specific references to shared history
   - Inside jokes or references
   - Personal sign-offs or greetings

4. **Conversational markers**
   - Em-dashes and parenthetical asides
   - "Look," "Listen," "Here's the thing"
   - Question-then-answer structure
   - Specific idioms they use

5. **Their formality level**
   - If they write casually, keep it casual
   - If they're more formal, respect that
   - Don't make them sound like someone else

### Common Voice-Killing Patterns (Never Do These)

❌ **Corporatizing Casual Communication**
```
ORIGINAL: "Hey! Quick thought on this..."
BAD REVISION: "Good morning. I am writing to share a consideration regarding..."

Why it's wrong: Destroyed the casual, energetic opening. Made it stiff and formal.
```

❌ **Removing Humor**
```
ORIGINAL: "The cat situation has reached DEFCON 1. Send reinforcements (or at least more litter)."
BAD REVISION: "The cat situation requires immediate attention."

Why it's wrong: Stripped personality and relationship-building humor.
```

❌ **Over-Professionalizing Personality**
```
ORIGINAL: "Listen—we're at a crossroads here."
BAD REVISION: "The organization currently faces a decision point."

Why it's wrong: Lost the direct, personal engagement style.
```

❌ **Adding Headers Where They Used Flow**
```
ORIGINAL: "Three things I'm thinking about. First, we need..."
BAD REVISION: 
**Key Considerations**
**1. Strategic Priority Alpha**
We need...

Why it's wrong: They organized conversationally. Don't impose corporate structure.
```

❌ **Replacing Conversational with Business Language**
```
ORIGINAL: "I've been chewing on this for a while..."
BAD REVISION: "After careful consideration of this matter..."

Why it's wrong: Killed their natural way of expressing reflection.
```

### Voice Preservation Examples: Before/After

**Example 1: Preserving Rhythm & Asides**

ORIGINAL:
```
Look—I get it. Change is hard. (Hell, I hate it most of the time.) But here's what I'm seeing: we're stuck. And staying stuck is killing us slowly.
```

GOOD REVISION (resolving a values gap while preserving voice):
```
Look—I get it. Change is hard. (Hell, I hate it most of the time.) But here's what I'm seeing: we're stuck. And staying stuck hurts everyone—our team, our customers, our mission. We need to name that honestly.
```

Why it works: Preserved rhythm, parenthetical aside, "Look" opening, dash structure. Only changed the ending to add stakeholder consciousness.

BAD REVISION:
```
Change initiatives often face resistance. However, organizational stagnation presents significant risk to stakeholder value and long-term viability.
```

Why it fails: Completely unrecognizable. Stripped all personality.

---

**Example 2: Preserving Humor**

ORIGINAL:
```
The good news: we learned a lot. The bad news: we learned it the hard way. The expensive way. The "oh god why did we do that" way.
```

GOOD REVISION (adding accountability):
```
The good news: we learned a lot. The bad news: we learned it the hard way. The expensive way. The "oh god why did we do that" way. And I own that—this was my call.
```

Why it works: Kept the humor and escalating structure, just added ownership.

BAD REVISION:
```
We gained valuable insights from this experience, though the learning process involved higher costs than anticipated.
```

Why it fails: Turned personality into corporate-speak. Lost the humor that builds connection.

---

**Example 3: Preserving Conversational Markers**

ORIGINAL:
```
Here's the thing. We've been dancing around this for months. Talking about it without talking about it. And honestly? It's exhausting.
```

GOOD REVISION (adding stakeholder consciousness):
```
Here's the thing. We've been dancing around this for months. Talking about it without talking about it. And honestly? It's exhausting for all of us—leadership, team members, everyone caught in the uncertainty.
```

Why it works: Kept "here's the thing," the fragment sentences, the "honestly?" marker. Just made stakeholder impact explicit.

BAD REVISION:
```
An extended period of ambiguity regarding this issue has created organizational fatigue.
```

Why it fails: Removed all conversational energy and personal voice.

---

**Example 4: Preserving Personal Callbacks**

ORIGINAL:
```
Remember that disaster of a launch in 2019? When everything that could go wrong did go wrong, and then some? We're not doing that again.
```

GOOD REVISION (adding learning/accountability):
```
Remember that disaster of a launch in 2019? When everything that could go wrong did go wrong, and then some? We're not doing that again—here's what we learned and how we're applying it.
```

Why it works: Preserved the callback and conversational question. Extended it to show growth.

BAD REVISION:
```
Informed by previous unsuccessful product releases, we will implement improved protocols.
```

Why it fails: Lost the shared memory reference that builds relationship.

---

**Example 5: Preserving Em-Dash Style**

ORIGINAL:
```
We have a choice—a real choice—about what kind of company we want to be.
```

GOOD REVISION (adding stakeholder dimension):
```
We have a choice—a real choice—about what kind of company we want to be and who we want to be for our stakeholders.
```

Why it works: Preserved the em-dash emphasis structure they use for important points.

BAD REVISION:
```
The organization must determine its desired culture and values.
```

Why it fails: Stripped the emphasis and urgency that the em-dashes created.

---

**Example 6: Preserving Self-Deprecating Humor**

ORIGINAL:
```
Am I overthinking this? Absolutely. It's kind of my superpower. But bear with me...
```

GOOD REVISION (adding values clarity):
```
Am I overthinking this? Absolutely. It's kind of my superpower. But bear with me—what I'm really trying to sort out is how we honor our values while moving forward.
```

Why it works: Kept the self-deprecating humor, just clarified the purpose of the overthinking.

BAD REVISION:
```
Careful consideration of this matter reveals several important dimensions.
```

Why it fails: Removed vulnerability and humor that build trust.

---

### When Voice Preservation Requires Changes

Sometimes preserving authentic voice means NOT preserving certain elements that contradict their stated values. Examples:

**Scenario: They claim to value transparency but use opaque corporate language**

ORIGINAL:
```
"We value radical transparency. Due to ongoing strategic considerations, we're unable to provide details at this time."
```

This is an integrity issue disguised as voice. The corporate language contradicts the transparency value.

GOOD REVISION:
```
"We value radical transparency. Here's what we can share now: [specifics]. Here's what we're still determining: [specifics]. Here's when we'll know more: [date]."
```

You're changing the language to align with their stated value of transparency.

---

### Voice Preservation Across Formality Levels

**Casual Voice Preservation**

ORIGINAL:
```
"Hey team—quick heads up. We're switching things around next week."
```

GOOD REVISION (adding stakeholder consideration):
```
"Hey team—quick heads up. We're switching things around next week. I know schedule changes are disruptive, so here's what we're doing to make it easier..."
```

Stayed casual, added care.

---

**Professional Voice Preservation**

ORIGINAL:
```
"Good morning. I'm writing to inform you of an upcoming organizational change."
```

GOOD REVISION (adding transparency):
```
"Good morning. I'm writing to inform you of an upcoming organizational change. I want to be transparent about why we're making this shift and how it affects different groups."
```

Stayed professional, added openness.

---

**Energetic Voice Preservation**

ORIGINAL:
```
"This is HUGE! We just closed the biggest deal in company history! Let's celebrate!"
```

GOOD REVISION (adding stakeholder recognition):
```
"This is HUGE! We just closed the biggest deal in company history! Major credit to the sales team, the delivery team, and everyone who made this possible. Let's celebrate!"
```

Kept the energy, added recognition.

---

### The Voice Preservation Checklist

Before finalizing Section C, ask:

- [ ] Would someone who knows them recognize this?
- [ ] Did I keep their humor/wit/playfulness?
- [ ] Did I preserve personal callbacks and relationship markers?
- [ ] Did I maintain their sentence rhythm and paragraph structure?
- [ ] Did I keep their conversational markers (em-dashes, asides, etc.)?
- [ ] Did I respect their formality level?
- [ ] Did I avoid corporatizing their casual language?
- [ ] Did I avoid adding headers/structure where they used flow?
- [ ] Did I strengthen values alignment WITHOUT destroying personality?
- [ ] **Did I keep it as concise as their original while making necessary changes?**

If you can't check all boxes, revision needs more work.

---

### Conciseness Guidance

**When revising to resolve integrity tensions:**

**Their paragraph = 2-3 sentences** → Your revision should be 3-4 sentences max
**Their paragraph = 4-5 sentences** → Your revision should be 5-6 sentences max

**Example: Resolving "No Strings" tension**

TOO VERBOSE (even if accurate):
```
"This first skill is a genuine offer of service to the movement—no obligation to go anywhere beyond it. Use it, share it, test it. If it's valuable, great. And if, down the road, you ever want to explore the other frameworks, we can have that conversation then. If not, no worries—we'll still have learned something either way."
```
(5 sentences for a 2-sentence original)

BETTER:
```
"I'm offering this as service to the movement, AND I'm transparent that other frameworks exist if they're ever helpful. Both are true. Use it, test it—no obligation to explore further."
```
(3 sentences, tighter, same integrity resolution)

**The principle:** Make revisions AS CONCISE AS POSSIBLE while fully resolving the values gap. Don't add teaching verbosity to Section C—save that for Section B.

**Section B can be detailed (it's teaching).  
Section C should be tight (it's their communication).**

---

### Quick Reference: Voice Elements to Protect

**ALWAYS PRESERVE:**
- Humor, jokes, playful language
- Personal callbacks and shared references
- Self-deprecating or vulnerable moments
- Their specific conversational markers
- Sentence rhythm and paragraph flow
- Their formality level
- Relationship-building asides

**NEVER:**
- Corporatize casual language
- Remove personality for "professionalism"
- Add structure they didn't use
- Replace their phrases with business jargon
- Strip humor that builds connection
- Make them sound like a different person

### The Ultimate Test

Read the revision out loud. 

Does it sound like something THEY would say?

Or does it sound like generic business communication that could come from anyone?

If it's the latter, you've failed voice preservation. Go back and restore their personality while keeping the values strengthening.
